/*
 * Decompiled with CFR 0.152.
 */
package org.raydunn.vulcanpunishmentsplus;

import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.raydunn.vulcanpunishmentsplus.Metrics;
import org.raydunn.vulcanpunishmentsplus.UpdateChecker;

public final class Vulcan_PunishmentsPlus
extends JavaPlugin
implements Listener {
    FileConfiguration config = this.getConfig();
    String VersionMsg;
    String VulcanVersion;

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            Plugin vulcan = this.getServer().getPluginManager().getPlugin("Vulcan");
            this.VulcanVersion = vulcan.getDescription().getVersion();
            if (vulcan != null && vulcan.isEnabled()) {
                this.getLogger().info("Vulcan has been detected.");
                this.getLogger().info("Vulcan Punishhments+ will try to enable.");
                this.config.options().copyDefaults(true);
                this.saveDefaultConfig();
                File file = new File(this.getDataFolder().getParentFile(), "Vulcan" + System.getProperty("file.separator") + "config.yml");
                if (!file.exists()) {
                    this.getLogger().severe("An issue occured trying to get the config of Vulcan.");
                    this.getServer().getPluginManager().disablePlugin((Plugin)this);
                } else {
                    YamlConfiguration vulcan2 = YamlConfiguration.loadConfiguration((File)file);
                    if (vulcan2.getBoolean("settings.enable-api")) {
                        Bukkit.getLogger().info("Vulcan API is enabled");
                    } else {
                        this.getLogger().severe("Vulcan API is disabled in Vulcan's config.yml. This must be enabled");
                        this.getLogger().severe("We have changed it to true for you, but you need to restart the server for it to work");
                        vulcan2.set("settings.enable-api", (Object)true);
                        try {
                            vulcan2.save(file);
                            this.getServer().getPluginManager().disablePlugin((Plugin)this);
                        }
                        catch (IOException var4) {
                            this.getLogger().severe("You need to do it yourself as we are unable to save the vulcan.");
                            var4.printStackTrace();
                            this.getServer().getPluginManager().disablePlugin((Plugin)this);
                        }
                    }
                    File dir = this.getDataFolder();
                    File dbFile = new File(dir, "db.yml");
                    if (!dir.exists()) {
                        dir.mkdir();
                    }
                    if (!dbFile.exists()) {
                        try {
                            dbFile.createNewFile();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    new UpdateChecker(this, 12345).getVersion(version -> {
                        String updateMessage = Vulcan_PunishmentsPlus.colorize(this.getConfig().getString("message-update-available").replace("%current_version%", this.getDescription().getVersion().toString()).replace("%latest_version%", version.toString()).replace("%link%", "https://www.spigotmc.org/resources/vulcan-punishments.123985/"));
                        if (!this.getDescription().getVersion().equals(version)) {
                            this.getLogger().info(updateMessage);
                        }
                    });
                    int pluginId = 25669;
                    Metrics metrics = new Metrics((Plugin)this, pluginId);
                    this.getLogger().info("-----------------------------");
                    this.getLogger().info("Vulcan Punishments+");
                    this.getLogger().info("Enabled.");
                    this.getLogger().info(" Made by Ray_y");
                    this.getLogger().info("-----------------------------");
                }
            } else {
                this.getLogger().severe("Vulcan is not installed! Plugin Disabling");
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
            }
        }, 1L);
    }

    public void onDisable() {
        this.getLogger().info("-----------------------------");
        this.getLogger().info("Vulcan Punishments+");
        this.getLogger().info("Disabled.");
        this.getLogger().info("-----------------------------");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("vulcan-punishmentsplus")) {
            if (sender instanceof ConsoleCommandSender || sender.hasPermission("vulcanpunishmentsplus.help")) {
                if (args.length == 0) {
                    sender.sendMessage("\u00a77------------------------");
                    sender.sendMessage("\u00a77VulcanPunishments\u00a7c+");
                    sender.sendMessage("");
                    sender.sendMessage("\u00a7fPlugin Help:");
                    sender.sendMessage("\u00a77 - /vulcan-punishmentsplus help | Sends this help menu");
                    sender.sendMessage("\u00a77 - /vulcan-punishmentsplus support | Sends how to access support");
                    sender.sendMessage("\u00a77 - /vulcan-punishmentsplus reload | Reloads plugin config");
                    sender.sendMessage("\u00a77------------------------");
                    return true;
                } else if (args[0].equalsIgnoreCase("reload")) {
                    if (sender instanceof ConsoleCommandSender || sender.hasPermission("vulcanpunishmentsplus.reload")) {
                        String rldMsg = Vulcan_PunishmentsPlus.colorize(this.getConfig().getString("message-reload"));
                        String prefix = Vulcan_PunishmentsPlus.colorize(this.getConfig().getString("plugin-prefix"));
                        sender.sendMessage(prefix + " " + rldMsg);
                        this.reloadConfig();
                        this.config = this.getConfig();
                        String rldSuccess = Vulcan_PunishmentsPlus.colorize(this.getConfig().getString("message-reload-success"));
                        String prefix1 = Vulcan_PunishmentsPlus.colorize(this.getConfig().getString("plugin-prefix"));
                        sender.sendMessage(prefix1 + " " + rldSuccess);
                        return true;
                    } else {
                        String prefix = Vulcan_PunishmentsPlus.colorize(this.getConfig().getString("plugin-prefix"));
                        String nopermsMsg = Vulcan_PunishmentsPlus.colorize(this.getConfig().getString("message-no-permission"));
                        sender.sendMessage(prefix + " " + nopermsMsg);
                    }
                    return true;
                } else if (args[0].equalsIgnoreCase("support")) {
                    if (sender instanceof ConsoleCommandSender || sender.hasPermission("vulcanpunishmentsplus.support")) {
                        sender.sendMessage("\u00a77------------------------");
                        sender.sendMessage("\u00a77Vulcan Punishments\u00a7c+ \u00a7fSupport");
                        sender.sendMessage("If you are having issues with the plugin,");
                        sender.sendMessage("please make a ticket in the support Discord");
                        sender.sendMessage("\u00a79https://discord.gg/EshbnCjhfc");
                        sender.sendMessage("I cannot stress this enough, we are \u00a7cNOT");
                        sender.sendMessage("\u00a7cVulcan Anticheat support\u00a7f. If you have");
                        sender.sendMessage("issues with the Vulcan plugin,");
                        sender.sendMessage("make a ticket in Vulcan's Discord.");
                        sender.sendMessage("\u00a77------------------------");
                        return true;
                    } else {
                        String prefix = Vulcan_PunishmentsPlus.colorize(this.getConfig().getString("plugin-prefix"));
                        String nopermsMsg = Vulcan_PunishmentsPlus.colorize(this.getConfig().getString("message-no-permission"));
                        sender.sendMessage(prefix + " " + nopermsMsg);
                    }
                    return true;
                } else if (args[0].equalsIgnoreCase("help")) {
                    sender.sendMessage("\u00a77------------------------");
                    sender.sendMessage("\u00a77VulcanPunishments\u00a7c+");
                    sender.sendMessage("");
                    sender.sendMessage("\u00a7fPlugin Help:");
                    sender.sendMessage("\u00a77 - /vulcan-punishmentsplus help | Sends this help menu");
                    sender.sendMessage("\u00a77 - /vulcan-punishmentsplus support | Sends how to access support");
                    sender.sendMessage("\u00a77 - /vulcan-punishmentsplus reload | Reloads plugin config");
                    sender.sendMessage("\u00a77------------------------");
                    return true;
                } else if (args[0].equalsIgnoreCase("about")) {
                    if (!(sender instanceof ConsoleCommandSender) && !sender.hasPermission("vulcanpunishmentsplus.viewabout")) return true;
                    sender.sendMessage("\u00a77please wait...");
                    new UpdateChecker(this, 12345).getVersion(version -> {
                        this.VersionMsg = this.getDescription().getVersion().equals(version) ? "\u00a7a" + this.getDescription().getVersion() : "\u00a7c" + this.getDescription().getVersion();
                        sender.sendMessage("");
                        sender.sendMessage("\u00a7cVulcan Punishments\u00a7f+ \u00a77Addon by Ray_y");
                        sender.sendMessage("");
                        sender.sendMessage("\u00a771: Version: " + this.VersionMsg);
                        sender.sendMessage("\u00a772: Vulcan Version: " + this.VulcanVersion);
                        sender.sendMessage("\u00a773: Server Version: " + this.getServer().getVersion());
                        sender.sendMessage("\u00a774: SpigotMC Page: https://www.spigotmc.org/resources/vulcan-punishments.123985/");
                        sender.sendMessage("\u00a775: Docs: https://plugindocs.ray-y.co.uk/vulcanpunishmentsplus/\n");
                    });
                    return true;
                } else {
                    String prefix = Vulcan_PunishmentsPlus.colorize(this.getConfig().getString("plugin-prefix"));
                    String messageUnknownArg = Vulcan_PunishmentsPlus.colorize(this.getConfig().getString("message-unknown-argument"));
                    sender.sendMessage(prefix + " " + messageUnknownArg);
                }
                return true;
            } else {
                String prefix = Vulcan_PunishmentsPlus.colorize(this.getConfig().getString("plugin-prefix"));
                String nopermsMsg = Vulcan_PunishmentsPlus.colorize(this.getConfig().getString("message-no-permission"));
                sender.sendMessage(prefix + " " + nopermsMsg);
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("vpp-cmd")) {
            if (!(sender instanceof ConsoleCommandSender)) return false;
            Player p = Bukkit.getPlayer((String)args[0]);
            if (p != null) {
                String uuid = p.getUniqueId().toString();
                File dir = this.getDataFolder();
                File dbFile = new File(dir, "db.yml");
                YamlConfiguration db = YamlConfiguration.loadConfiguration((File)dbFile);
                int current = db.getInt(uuid, 0);
                if (current < 10) {
                    db.set(uuid, (Object)(current + 1));
                    try {
                        db.save(dbFile);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                int level = db.getInt(uuid);
                ConfigurationSection section = this.getConfig().getConfigurationSection("punishment-" + level);
                if (section == null) return true;
                ConfigurationSection commandsSection = section.getConfigurationSection("commands");
                if (commandsSection != null) {
                    for (String key : commandsSection.getKeys(false)) {
                        String cmd = commandsSection.getString(key);
                        if (cmd == null) continue;
                        cmd = cmd.replace("%player%", p.getName());
                        Bukkit.getServer().dispatchCommand((CommandSender)this.getServer().getConsoleSender(), cmd);
                    }
                    return true;
                } else {
                    String cmd = section.getString("command");
                    if (cmd == null) return true;
                    cmd = cmd.replace("%player%", p.getName());
                    Bukkit.getServer().dispatchCommand((CommandSender)this.getServer().getConsoleSender(), cmd);
                }
                return true;
            }
            sender.sendMessage("Player not found!");
            return true;
        }
        if (!command.getName().equalsIgnoreCase("reset-vulcanpunishments")) return true;
        if (sender instanceof ConsoleCommandSender || sender.hasPermission("vulcanpunishmentsplus.resetpunishments")) {
            if (args.length == 0) {
                String prefix = this.getConfig().getString("plugin-prefix").replace("&", "\u00a7");
                sender.sendMessage(prefix + " \u00a77Incorrect Command Usage");
                return true;
            } else {
                OfflinePlayer p = Bukkit.getOfflinePlayer((String)args[0]);
                if (p == null) return true;
                String uuid = p.getUniqueId().toString();
                File dir = this.getDataFolder();
                File dbFile = new File(dir, "db.yml");
                YamlConfiguration db = YamlConfiguration.loadConfiguration((File)dbFile);
                String prefix = Vulcan_PunishmentsPlus.colorize(this.getConfig().getString("plugin-prefix"));
                String messageReset = Vulcan_PunishmentsPlus.colorize(this.getConfig().getString("message-cleared-punishments").replace("%player%", p.getName().toString()));
                String messageInvalidPlayer = Vulcan_PunishmentsPlus.colorize(this.getConfig().getString("message-invalid-player"));
                if (!db.contains(uuid)) {
                    sender.sendMessage(prefix + " " + messageInvalidPlayer);
                    return true;
                } else {
                    sender.sendMessage(prefix + " " + messageReset);
                    db.set(uuid, null);
                    try {
                        db.save(dbFile);
                        return true;
                    }
                    catch (IOException e) {
                        sender.sendMessage(e.toString());
                    }
                }
            }
            return true;
        } else {
            String prefix = Vulcan_PunishmentsPlus.colorize(this.getConfig().getString("plugin-prefix"));
            String nopermsMsg = Vulcan_PunishmentsPlus.colorize(this.getConfig().getString("message-no-permission"));
            sender.sendMessage(prefix + " " + nopermsMsg);
        }
        return true;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        String prefix = Vulcan_PunishmentsPlus.colorize(this.getConfig().getString("plugin-prefix"));
        String isUpdateEnabled = this.getConfig().getString("check-for-updates");
        if (isUpdateEnabled.equalsIgnoreCase("true") && e.getPlayer().hasPermission("vulcanpunishmentsplus.updatecheck")) {
            new UpdateChecker(this, 12345).getVersion(version -> {
                if (!this.getDescription().getVersion().equals(version)) {
                    String updateMessage = Vulcan_PunishmentsPlus.colorize(this.getConfig().getString("message-update-available").replace("%current_version%", this.getDescription().getVersion().toString()).replace("%latest_version%", version.toString()).replace("%link%", "https://www.spigotmc.org/resources/vulcan-punishments.123985/"));
                    e.getPlayer().sendMessage(prefix + " " + updateMessage);
                }
            });
        }
    }

    public static String colorize(String input) {
        if (input == null) {
            return null;
        }
        String colored = ChatColor.translateAlternateColorCodes((char)'&', (String)input);
        Pattern hexPattern = Pattern.compile("&#([A-Fa-f0-9]{6})");
        Matcher matcher = hexPattern.matcher(colored);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String hex = matcher.group(1);
            StringBuilder replacement = new StringBuilder("\u00a7x");
            for (char c : hex.toCharArray()) {
                replacement.append('\u00a7').append(c);
            }
            matcher.appendReplacement(buffer, replacement.toString());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }
}

